using System;
using System.ComponentModel.Composition;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VideoVisit.Messages;
using VIMT.VideoVisit.Processors;

namespace VIMT.VideoVisit.MessageHandler
{
	[Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTTmpCreateAppointmentRequest)]
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,ScheduleMeeting method, MessageHandler.
	/// Code Generated by IMS on: 4/12/2016 6:51:29 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
    public class VIMTTmpCreateAppointmentMessageHandler : RequestResponseHandler
	{
		public override IMessageBase HandleRequestResponse(object message)
		{
			try
			{
				LogMessageReceipt(message);
                var processor = new VIMTTmpCreateAppointmentProcessor();
                return processor.Execute((VIMTTmpCreateAppointmentRequest)message);
			}
			catch (Exception ex)
			{
                VIMTTmpCreateAppointmentRequest msg = (VIMTTmpCreateAppointmentRequest)message;
                LogHelper.LogError(msg.OrganizationName, msg.UserId, "VIMTTmpCreateAppointmentMessageHandler.HandleRequestResponse", ex);
                throw new Exception(string.Format("VIMTTmpCreateAppointmentMessageHandler Error: {0}", ex.Message), ex);
			}
		}
	}
}
